﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Areas/Members/Views/Shared/MembersMasterBS.Master" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    Loan Calculator
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsSection" runat="server">
    <style type="text/css">
        
        .td_amount_col {
            text-align: right;
        }
        
    </style>

    
    <script type="text/javascript"  >
        $(document).ready(function () {
            var LoanTypeList = null;
            var SchemeBalsList = null;
            var currLoanType = null;
            var LoanBalances = null;
            //note no quotes to avoid 'true' and 'false' strings which will both evaluate to true on if (NoSalaryMazematics) {
            var NoSalaryMazematics =<%= ((XtremeERP.Common.Data.MemberPortalSettings)ViewBag.PortalSettings).LoanCalcNoSalaryComputations ? "true" : "false" %>;
            var bolIsSaccoBalozi =<%= (XtremeERP.Common.Utilities.Utils.bolIsSaccoBalozi ? "true" : "false") %>;

            InitSummary();

            if (NoSalaryMazematics) {
                $('#rowUsesSalary').hide();
                $('#rowNetSalary').hide();
            }
            $('#btnCalculate').on('click', function (event) {
                event.preventDefault();
                if (document.getElementById("cboLoanType").selectedIndex == 0) {
                    alert("Select Loan Type");
                    return;
                }
                if (!isNumber(ConvertMoneyToDouble($("#txtRequestedAmount").val()))) {
                    alert("Invalid Loan Amount");
                    return;
                }
                if (!isNumber(ConvertMoneyToDouble($("#txtSalary").val()))) {
                    alert("Invalid Salary Amount");
                    return;
                }
                if (!isNumber(ConvertMoneyToDouble($("#txtRepaymentPeriod").val()))) {
                    alert("Invalid Repayment Period");
                    return;
                }
                if (+($("#txtRepaymentPeriod").val()) < 1) {
                    alert("Invalid Repayment Period");
                    return;
                }
                var csrfToken = $("input[name='__RequestVerificationToken']").val();


                var outData = {
                    'LoanAmount': $("#txtRequestedAmount").val(),
                    'SalaryAmount': $("#txtSalary").val(),
                    'RepaymentPeriod': $("#txtRepaymentPeriod").val(),
                    'LoanTypeCode': $("#cboLoanType").val()
                }
                outData = JSON.stringify(outData);
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/MembersSystemApi/CalculateMemberQualifingLoanAmount") %>",
                    data: outData,
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        $("#lblRecommendedAmount").text((+response.RecommenedAmount).formatMoney());
                        $("#lblRepaymentAmount").text((+response.RepaymentAmount).formatMoney());
                        $("#pInfo").html(response.Reasons);
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }

                });
            });
            $("#cboLoanType").on('change', function () {
                var LoanTypes = LoanTypeList.filter(function (lnType) {
                    return lnType.LoanTypeCode == $("#cboLoanType").val();
                });
                currLoanType = null;
                $("#lblMaxAmount").text("");
                $("#lblRepaymentPeriod").text("");
                $("#txtRepaymentPeriod").val("");
                $("#lblSchemeUsed").text("");
                $("#lblSchemeBalance").text("");
                $("#lblMultiplier").text("");
                $("#lblSharesMultiplied").text("");
                $("#lblOtherLoansBalances").text("");
                $("#lblRecommendedAmount").text("");
                $("#lblRepaymentAmount").text("");
                
                $("#lblUsesSalary").text("");

                $("#lblInterestRate").text("");
                $("#pInfo").text("");
                

                if (LoanTypes.length > 0) {
                    currLoanType = LoanTypes[0];

                    var SchemeBalance = 0;

                    var SharesMultiplier = currLoanType.LoanNumOfTimesShares;

                    var SchemeUsed = currLoanType.SchemeUsed;
                    var SharesMultiplied = 0;
                    var LoanTiedToSchemeTotals = 0;
                    $("#lblInterestRate").val(currLoanType.Percentage);
                    $("#txtSalary").prop("disabled", (currLoanType.UsesSalary.toUpperCase() == "Y" ? false : true)); 
                    if (currLoanType.UsesSalary.toUpperCase() == "N") {
                        $("#txtSalary").val("0");
                    }
                    $("#lblUsesSalary").text((currLoanType.UsesSalary.toUpperCase()=="Y"?"YES":"NO"));
                    if (SchemeUsed.length > 0) {
                        if (SchemeBalsList != null) {
                            var SchemeList = SchemeBalsList.filter(function (schemeType) {
                                return schemeType.BalCode == SchemeUsed;
                            });
                            if (SchemeList != SchemeList.length > 0) {
                                SchemeBalance = SchemeList[0].BalAmount;
                            }
                        }
                        $("#lblSchemeUsed").text(SchemeUsed);
                        SharesMultiplied = (+SharesMultiplier) * (+SchemeBalance);
                        if (+SharesMultiplied < 0) {
                            SharesMultiplied = 0;
                        }
                        var LoanBalancesTiedToScheme;
                        LoanTiedToSchemeTotals = 0;
                        if (bolIsSaccoBalozi) {
                            //exclude: M-cash loan(91), Default loan(29), Okoa Advance(31), Quick pesa loans(20) 
                            //exclude: M-cash loan(Z), Default loan(D), Okoa Advance(O), Quick pesa loans(Q) 
                            LoanBalancesTiedToScheme = LoanBalances.filter(function (lnType) {
                                return ((lnType.SchemeUsed == SchemeUsed) && (lnType.BalCode.toUpperCase() != "Z" && lnType.BalCode.toUpperCase() != "D" && lnType.BalCode.toUpperCase() != "O" && lnType.BalCode.toUpperCase() != "Q"));
                            });
                            
                        } else {
                            LoanBalancesTiedToScheme = LoanBalances.filter(function (lnType) {
                                return lnType.SchemeUsed == SchemeUsed;
                            });
                        }
                        if (LoanBalancesTiedToScheme.length > 0) {
                            for (var i = 0; i < LoanBalancesTiedToScheme.length; i++){
                                LoanTiedToSchemeTotals += (+LoanBalancesTiedToScheme[i].BalAmount);
                            }
                        }
                    }
                    
                    $("#lblOtherLoansBalances").text((+LoanTiedToSchemeTotals).formatMoney());
                    $("#lblMaxAmount").text((+currLoanType.LoanMaxAmount).formatMoney());
                    $("#lblRepaymentPeriod").text(+currLoanType.LoanMaxDuration);
                    $("#txtRepaymentPeriod").val(+currLoanType.LoanMaxDuration);
                    $("#lblSchemeBalance").text((+SchemeBalance).formatMoney());
                    $("#lblMultiplier").text(SharesMultiplier);
                    $("#lblSharesMultiplied").text((+SharesMultiplied).formatMoney());
                    $("#lblInterestRate").text(+currLoanType.Percentage);
                    
                    
                }
            });

            

            function InitSummary() {

                
                $("#tblAllLoans > tbody:last").children().remove();
                

                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/MembersSystemApi/GetMemberLoanSummary") %>",
                    data: "{}",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {

                        LoanBalances = response.LoanBalances;
                        SchemeBalsList = response.SchemeBalances;

                        var TotalLoanBalance = response.TotalLoanBalance;
                        var tbl_row = "";

                        $.each(LoanBalances, function (index, LoanBalance) {
                            if ((+LoanBalance.BalAmount) != 0) {
                                tbl_row += "<tr><td>" + LoanBalance.BalName + "</td><td class='td_amount_col'>" + (+LoanBalance.BalAmount).formatMoney() + "</td><td>" + LoanBalance.SchemeUsed + "</td></tr>";
                            }
                        });

                        tbl_row += "<tr><td>Total Loan Balance:</td><td class='td_amount_col'>" + (+TotalLoanBalance).formatMoney() + "</td><td></td></tr>";

                        $("#bdAllLoans").append(tbl_row);

                        LoanTypeList = response.CalcLoanTypes;
                        $("#cboLoanType").empty();
                        $("#cboLoanType").append('<option selected>(SELECT LOAN)</option>');
                        $.each(LoanTypeList, function (index, LoanType) {
                            $("#cboLoanType").append("<option value='" + LoanType.LoanTypeCode + "'>" + LoanType.LoanTypeName + "</option'>");
                        });
                    },
                    error: function (xhr, status, error) {

                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });

            }



            $(function () {
                $("#tabs").tabs();
            });
            $(function () {
                $("#accordion").accordion({
                    heightStyle: "content"
                });
            });

        });
    </script>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    
        <%= Html.AntiForgeryToken() %> 
        <% XtremeERP.Common.Data.SaccoSettings saccoSettings = ViewBag.saccoSettings as XtremeERP.Common.Data.SaccoSettings; %>
        <% XtremeERP.Common.Data.SaccoMember saccoMember = ViewBag.SaccoMember as XtremeERP.Common.Data.SaccoMember; %>
        <% XtremeERP.Common.Data.MemberPortalSettings portalSettings = ViewBag.PortalSettings as XtremeERP.Common.Data.MemberPortalSettings; %>
        
        
       
              <div class="row">  
                <div class="col-md-4 col-md-offset-4"> 
                    
                    <div class="table-responsive" id="divAllLoans" style="margin-left:10px">
                       <table id='tblAllLoans' class="table table-bordered">
                           
                            <caption>Current Loan Balances</caption>
                            <thead class="thead-dark">
                                <tr>
                                <th><b>Loan Type</b></th>
                                <th><b>Loan Balance</b></th>
                                <th><b>Scheme</b></th>
                                </tr>
                            </thead>
                            <tbody id='bdAllLoans'>
                            </tbody>
                            <tfoot><tr><td></td><td></td><td></td></tr></tfoot>
                        </table>
                        
                    </div>
                </div> 
                  </div>
              <div class="row"> 
                <div class="col-md-4 col-md-offset-4">  
                    <div class="table-responsive" id="divCalculator" style="margin-left:2px">
                       <table id='tblCalculator' class="table table-bordered">
                            <caption><b>Loan Calculator</b></caption>
                                
                            <tbody id='bdCalculator'>
                                <tr>
                                    <td>Loan Type</td>
                                    <td><select id="cboLoanType"></select></td>
                                </tr>
                                <tr>
                                    <td>Max. Loan Amount</td>
                                    <td class="td_amount_col"><label id="lblMaxAmount"></label></td>
                                </tr>
                                <tr>
                                    <td>Max. Repayment Period (Months)</td>
                                    <td class="td_amount_col"><label id="lblRepaymentPeriod"></label></td>
                                </tr>
                                <tr>
                                    <td>Monthly Interest Rate (%)</td>
                                    <td class="td_amount_col"><label id="lblInterestRate"></label></td>
                                </tr>
                                <tr>
                                    <td>Scheme Used</td>
                                    <td class="td_amount_col"><label id="lblSchemeUsed"></label></td>
                                </tr>
                                <tr>
                                    <td>Scheme Balance</td>
                                    <td class="td_amount_col"><label id="lblSchemeBalance"></label></td>
                                </tr>
                                <tr>
                                    <td>Multiplier</td>
                                    <td class="td_amount_col"><label id="lblMultiplier"></label></td>
                                </tr>
                                <tr>
                                    <td>Shares Multiplied</td>
                                    <td class="td_amount_col"><label id="lblSharesMultiplied" ></label></td>
                                </tr>
                                <tr>
                                    <td>Loan Balances tied to Scheme</td>
                                    <td class="td_amount_col"><label id="lblOtherLoansBalances" ></label></td>
                                </tr>
                                <tr>
                                    <td>Amount To Borrow</td>
                                    <td class="td_amount_col"><input type="number" id="txtRequestedAmount" class="td_amount_col" /></td>
                                </tr>
                                <tr>
                                    <td>Repayment Period</td>
                                    <td class="td_amount_col"><input type="number" id="txtRepaymentPeriod" class="td_amount_col" /></td>
                                </tr>

                                <tr id="rowUsesSalary">
                                    <td>Uses Salary</td>
                                    <td class="td_amount_col"><label id="lblUsesSalary"></label></td>
                                </tr>
                                <tr id="rowNetSalary">
                                    <td>Net Salary After Deductions</td>
                                    <td class="td_amount_col"><input type="number" id="txtSalary" class="td_amount_col" value="0" /></td>
                                </tr>
                                <tr>
                                    <td>Recommended Amount</td>
                                    <td class="td_amount_col"><label id="lblRecommendedAmount"></label></td>
                                </tr>
                                <tr>
                                    <td>Monthly Repayment</td>
                                    <td class="td_amount_col"><label id="lblRepaymentAmount"></label></td>
                                </tr>
                                <tr>
                                    <td></td>
                                    <td class="td_amount_col"><input type="button" id="btnCalculate" value="Calculate"/></td>
                                </tr>
                            </tbody>
                        </table>
                        <p id="pInfo"></p>
                    </div>
                    <p><b>Disclaimer</b></p>
                        <p><%: portalSettings.LoanCalcDisclaimer %></p>
                </div> 
                </div> 
          
        <br />
        
         
      
    <div id="loading" style="display:none"><img src="<%: Url.Content("~/Content/images/ajax-loader.gif") %>"  alt="Ajax Loader" />Contacting server....</div>
    <div id="divStatementDlg" style="display:none" ><iframe id="ifStatementDlg" style="height:640px;width:1140px"></iframe></div>
    
</asp:Content>
